import React from "react";
import { alpha, useMediaQuery, useTheme } from "@mui/material";

const SubscribeImage = () => {
  const theme = useTheme();
  const isSmall = useMediaQuery(theme.breakpoints.down("sm"));
  return (
    <svg
      width={isSmall ? "200" : "307"}
      height={isSmall ? "160" : "233"}
      viewBox="0 0 58 51"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_373_3494)">
        <path
          d="M21.0068 7.20114C21.0068 7.35831 20.9432 7.50194 20.8377 7.60627C20.7348 7.7106 20.5914 7.77564 20.4344 7.77564H8.18513C7.86983 7.77564 7.61272 7.5182 7.61272 7.2025C7.61272 7.04532 7.67632 6.9017 7.78187 6.79737C7.88471 6.69304 8.02815 6.628 8.18513 6.628H8.7643C8.99299 6.09551 9.52075 5.72426 10.1351 5.72426C10.5492 5.72426 10.9227 5.89363 11.1933 6.16462C11.5546 5.55218 12.2191 5.14028 12.9823 5.14028C13.192 5.14028 13.3936 5.17145 13.5831 5.22971C13.9823 4.47907 14.7699 3.96826 15.6779 3.96826C16.7685 3.96826 17.686 4.70535 17.9621 5.70936C18.1624 5.60909 18.3897 5.55083 18.6306 5.55083C19.3112 5.55083 19.885 6.00609 20.065 6.628H20.4344C20.7483 6.628 21.0068 6.8868 21.0068 7.20114Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.3"
        />
        <path
          d="M46.7358 9.62055V13.4606C46.7358 13.9675 46.3254 14.3805 45.8171 14.3805H38.8529L36.751 15.1356C36.5343 15.2127 36.3281 15 36.4114 14.7872L37.2072 12.7306V9.62055C37.2072 9.11368 37.6176 8.70068 38.1259 8.70068H45.8171C46.3233 8.70068 46.7358 9.1116 46.7358 9.62055Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
        />
        <path
          d="M45.269 10.7082H38.8798C38.7402 10.7082 38.6256 10.5955 38.6256 10.4537C38.6256 10.3139 38.7381 10.1992 38.8798 10.1992H45.269C45.4085 10.1992 45.5231 10.3119 45.5231 10.4537C45.5231 10.5934 45.4106 10.7082 45.269 10.7082Z"
          fill="white"
        />
        <path
          d="M45.269 11.7297H38.8798C38.7402 11.7297 38.6256 11.617 38.6256 11.4752C38.6256 11.3354 38.7381 11.2207 38.8798 11.2207H45.269C45.4085 11.2207 45.5231 11.3333 45.5231 11.4752C45.5231 11.6149 45.4106 11.7297 45.269 11.7297Z"
          fill="white"
        />
        <path
          d="M45.269 12.7526H38.8798C38.7402 12.7526 38.6256 12.64 38.6256 12.4981C38.6256 12.3584 38.7381 12.2437 38.8798 12.2437H45.269C45.4085 12.2437 45.5231 12.3563 45.5231 12.4981C45.5231 12.6379 45.4106 12.7526 45.269 12.7526Z"
          fill="white"
        />
        <path
          d="M36.9705 42.019C39.2167 40.3245 44.171 36.3076 47.6315 31.4351C52.5972 24.4408 56.3807 25.6788 56.7559 28.4591C57.7244 35.65 45.0343 41.4764 39.823 43.5525L36.9721 42.0193L36.9705 42.019Z"
          fill="white"
        />
        <path
          d="M36.9705 42.019C39.2167 40.3245 44.171 36.3076 47.6315 31.4351C52.5972 24.4408 56.3807 25.6788 56.7559 28.4591C57.7244 35.65 45.0343 41.4764 39.823 43.5525L36.9721 42.0193L36.9705 42.019Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.5"
        />
        <path
          d="M37.9742 42.5601C41.7193 40.513 45.0106 37.9256 47.2783 35.9426C50.3114 33.291 52.2223 31.1171 52.2425 31.0958C52.3111 31.0185 52.4294 31.0105 52.5082 31.0795C52.5871 31.1485 52.595 31.2669 52.5264 31.3443C52.5079 31.3659 50.5832 33.5556 47.5326 36.2239C45.2908 38.1835 42.0585 40.7291 38.3702 42.7752L37.9755 42.5621L37.9742 42.5601Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.33"
        />
        <path
          d="M40.4445 35.8626C41.3959 34.473 43.2425 31.5428 44.2244 28.4273C45.6924 23.772 47.9102 23.7736 48.5754 25.2105C50.402 29.1558 43.7832 34.9857 41.6947 36.6933L40.4442 35.8639L40.4445 35.8626Z"
          fill="white"
        />
        <path
          d="M40.4445 35.8626C41.3959 34.473 43.2425 31.5428 44.2244 28.4273C45.6924 23.772 47.9102 23.7736 48.5754 25.2105C50.402 29.1558 43.7832 34.9857 41.6947 36.6933L40.4442 35.8639L40.4445 35.8626Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.5"
        />
        <path
          d="M38.8397 39.0651C41.3966 36.3881 43.4323 33.3771 44.7793 31.1404C46.569 28.1709 47.564 25.8857 47.573 25.8642C47.6083 25.7823 47.7044 25.7438 47.7857 25.7812C47.8675 25.8165 47.9058 25.9126 47.8705 25.9945C47.861 26.018 46.8588 28.3165 45.0586 31.3051C43.7086 33.5455 41.6724 36.5584 39.1149 39.2481L38.8388 39.0692L38.8397 39.0651Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.33"
        />
        <path
          d="M5.94482 27.1888C5.56776 24.0642 4.63657 21.1732 3.28874 22.2516C1.93883 23.33 3.63455 28.2714 6.46562 31.1353L7.19683 32.3409C5.16987 30.2175 1.77425 28.8033 0.757652 29.8587C-0.2527 30.9079 2.0909 31.6421 4.34492 31.955C6.06148 32.1928 7.12808 32.7435 7.64263 33.0772L11.0924 38.7695C7.87386 35.4155 2.51171 33.1919 0.903476 34.8606C-0.700588 36.5251 3.02001 37.6911 6.59686 38.1876C9.29878 38.563 10.9903 39.4266 11.8132 39.9564L12.5007 41.0911C12.7152 41.0035 12.9298 40.9138 13.1444 40.822L9.04046 34.0492C9.05921 33.3817 9.18211 32.4473 9.59042 31.298C10.3529 29.1516 10.7862 26.7299 9.39044 27.1429C8.1801 27.5017 7.77804 30.278 8.29675 32.8206L6.8781 30.4782C6.56353 29.6793 6.10939 28.5384 5.94691 27.1888H5.94482Z"
          fill="white"
        />
        <path
          d="M5.94482 27.1888C5.56776 24.0642 4.63657 21.1732 3.28874 22.2516C1.93883 23.33 3.63455 28.2714 6.46562 31.1353L7.19683 32.3409C5.16987 30.2175 1.77425 28.8033 0.757652 29.8587C-0.2527 30.9079 2.0909 31.6421 4.34492 31.955C6.06148 32.1928 7.12808 32.7435 7.64263 33.0772L11.0924 38.7695C7.87386 35.4155 2.51171 33.1919 0.903476 34.8606C-0.700588 36.5251 3.02001 37.6911 6.59686 38.1876C9.29878 38.563 10.9903 39.4266 11.8132 39.9564L12.5007 41.0911C12.7152 41.0035 12.9298 40.9138 13.1444 40.822L9.04046 34.0492C9.05921 33.3817 9.18211 32.4473 9.59042 31.298C10.3529 29.1516 10.7862 26.7299 9.39044 27.1429C8.1801 27.5017 7.77804 30.278 8.29675 32.8206L6.8781 30.4782C6.56353 29.6793 6.10939 28.5384 5.94691 27.1888H5.94482Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
          fillOpacity="0.7"
        />
        <path
          d="M53.5665 49.7411V49.7874H2.1357V49.7411C2.1357 49.2138 2.56334 48.7856 3.08998 48.7856H52.6122C53.1401 48.7856 53.5665 49.2138 53.5665 49.7411Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
        />
        <path
          d="M16.508 17.2407L6.31771 20.6864C6.19357 20.7286 6.05624 20.6901 5.97257 20.5894C5.88845 20.4892 5.87526 20.3472 5.93892 20.2329L8.47126 15.6929C8.54493 15.5609 8.70135 15.4993 8.8455 15.5455L10.4229 16.0521L11.3665 14.6929C11.4524 14.5687 11.6147 14.5229 11.7534 14.5827L16.5326 16.6507C16.6526 16.7029 16.7285 16.823 16.7231 16.9536C16.7176 17.0847 16.6321 17.1985 16.508 17.2407ZM6.89293 19.8243L15.5263 16.9051L11.7403 15.2666L10.8113 16.6054C10.7317 16.7201 10.5862 16.7691 10.4534 16.7264L8.89961 16.2276L6.89293 19.8243Z"
          fill="#9DD5BA"
        />
        <path
          d="M6.31737 20.6862C6.27645 20.7002 6.23189 20.7057 6.18687 20.7016C6.06182 20.6903 5.95542 20.6068 5.9154 20.488L3.87234 14.4786C3.83369 14.3653 3.86279 14.2405 3.94646 14.1553C4.03058 14.07 4.15563 14.0396 4.26977 14.0764L8.84517 15.5457C8.93566 15.5747 9.00795 15.6428 9.04297 15.7308C9.07798 15.8187 9.07116 15.9176 9.02523 16.0006L6.4929 20.5406C6.45379 20.6105 6.39058 20.6612 6.31737 20.6862ZM4.67538 14.8709L6.28645 19.6096L8.28313 16.0292L4.67538 14.8709Z"
          fill="#9DD5BA"
        />
        <path
          d="M16.5084 17.2408C16.4352 17.2657 16.3538 17.2635 16.2801 17.2313L11.501 15.1633C11.4137 15.1256 11.3482 15.0508 11.3223 14.9601C11.2964 14.869 11.3123 14.771 11.3664 14.6934L14.1024 10.752C14.1706 10.6536 14.2884 10.6024 14.4071 10.6187C14.5258 10.6355 14.6249 10.7171 14.6636 10.8305L16.7066 16.8399C16.7471 16.9582 16.7134 17.0893 16.6211 17.1741C16.5884 17.2045 16.5497 17.2267 16.5084 17.2408ZM12.108 14.7365L15.8763 16.3673L14.2652 11.6287L12.108 14.7365Z"
          fill="#9DD5BA"
        />
        <path
          d="M10.6518 16.725C10.589 16.7463 10.5194 16.7476 10.4526 16.7263L4.07559 14.6788C3.94554 14.637 3.85687 14.5164 3.85551 14.3804C3.8546 14.2438 3.94145 14.1223 4.07059 14.0783L14.2609 10.6326C14.3905 10.5886 14.5337 10.6326 14.616 10.7414C14.6983 10.8503 14.7015 10.9999 14.6237 11.112L10.8105 16.6052C10.7709 16.6628 10.715 16.7037 10.6518 16.725ZM5.18375 14.3699L10.4235 16.0524L13.5565 11.5387L5.18375 14.3699Z"
          fill="#9DD5BA"
        />
        <path
          d="M51.7174 20.8382L44.9582 22.1427C44.8758 22.1585 44.7922 22.1221 44.7481 22.0511C44.7039 21.98 44.708 21.8891 44.7584 21.822L46.7641 19.1598C46.8224 19.0824 46.9271 19.057 47.0143 19.0988L47.9687 19.5568L48.6866 18.776C48.7521 18.7047 48.8587 18.6897 48.9414 18.7396L51.7854 20.4661C51.8571 20.5096 51.8942 20.5927 51.8791 20.675C51.864 20.7576 51.7997 20.8224 51.7174 20.8382ZM45.3986 21.6452L51.1251 20.5401L48.8719 19.1725L48.165 19.9414C48.1045 20.0071 48.008 20.0259 47.9275 19.9871L46.9876 19.5358L45.3986 21.6452Z"
          fill="#9DD4BA"
        />
        <path
          d="M44.9584 22.1424C44.9312 22.1476 44.9026 22.1475 44.8745 22.141C44.7964 22.123 44.7364 22.0608 44.7212 21.982L43.9591 17.9911C43.9447 17.9159 43.974 17.8392 44.0348 17.7921C44.0956 17.7455 44.1775 17.7369 44.2465 17.77L47.0144 19.0987C47.069 19.1251 47.1091 19.1743 47.1232 19.2332C47.1375 19.292 47.1245 19.3545 47.0881 19.403L45.0823 22.0652C45.0515 22.106 45.007 22.1328 44.9584 22.1424ZM44.433 18.3093L45.034 21.4566L46.6156 19.3573L44.433 18.3093Z"
          fill="#9DD4BA"
        />
        <path
          d="M51.7177 20.8379C51.6692 20.8472 51.6179 20.8388 51.5742 20.8122L48.7302 19.0858C48.6785 19.0543 48.6434 19.0013 48.635 18.9414C48.6266 18.8814 48.6454 18.8206 48.6866 18.7759L50.7683 16.5112C50.8202 16.4548 50.8993 16.4323 50.9729 16.453C51.0465 16.4738 51.1023 16.5344 51.1165 16.6094L51.8787 20.6003C51.8937 20.6789 51.8609 20.7593 51.7948 20.8051C51.7715 20.8216 51.7451 20.8326 51.7177 20.8379ZM49.1523 18.8676L51.3948 20.2289L50.7938 17.0816L49.1523 18.8676Z"
          fill="#9DD4BA"
        />
        <path
          d="M48.0541 20.0031C48.0124 20.0112 47.9681 20.0062 47.9278 19.9869L44.0701 18.1349C43.9912 18.0972 43.9458 18.0131 43.9572 17.9264C43.9686 17.8397 44.0344 17.77 44.1203 17.7534L50.8795 16.4489C50.9654 16.4323 51.052 16.4726 51.0946 16.5488C51.1372 16.625 51.1259 16.7202 51.0666 16.7845L48.1653 19.9408C48.1348 19.9738 48.0957 19.995 48.0541 20.0031ZM44.7989 18.0349L47.9689 19.5566L50.353 16.9632L44.7989 18.0349Z"
          fill="#9DD4BA"
        />
        <path
          d="M44.1405 23.474L43.3279 28.5011L43.1719 29.4657C43.1719 30.2127 41.5718 40.0537 40.7428 40.0537L27.6359 31.0212L13.0894 41.0872C12.2609 41.0872 11.3897 30.4975 11.3897 29.7505L11.3319 28.5011L11.0996 23.489L13.4382 21.4736L26.701 10.0431C27.2481 9.65035 28.0238 9.65035 28.5708 10.0431L41.8214 21.4736L44.1405 23.474Z"
          fill="#0E5433"
        />
        <path
          d="M37.8495 23.4428V38.8166H17.3157V19.0039H33.3537L37.8495 23.4428Z"
          fill="white"
        />
        <path
          d="M37.8495 23.4433V23.9616H32.8339V18.9849L33.3537 19.0044L37.8495 23.4433Z"
          fill="black"
          fillOpacity="0.14"
        />
        <path
          d="M37.8497 23.4428H33.3539V19.0039L37.8497 23.4428Z"
          fill="white"
        />
        <path
          d="M27.9551 33.9542L35.472 26.3063C37.4464 24.2978 40.2639 23.1504 43.2214 23.1504C43.9158 23.1504 44.4792 23.6066 44.4792 24.1694V34.5891V44.6106C44.4792 45.1734 43.5402 46.0283 42.8458 46.0283H38.5746L27.9551 35.224C27.5999 34.8626 27.5999 34.3152 27.9551 33.9542Z"
          fill={alpha(theme.palette.primary.main, 0.5)}
        />
        <path
          d="M27.9551 33.9542L35.472 26.3063C37.4464 24.2978 40.2639 23.1504 43.2214 23.1504C43.9158 23.1504 44.4792 23.6066 44.4792 24.1694V34.5891V44.6106C44.4792 45.1734 43.5402 46.0283 42.8458 46.0283H38.5746L27.9551 35.224C27.5999 34.8626 27.5999 34.3152 27.9551 33.9542Z"
          fill={alpha(theme.palette.primary.main, 10)}
        />
        <path
          d="M27.3165 33.941L19.799 26.2931C17.8246 24.2846 15.0072 23.1372 12.0497 23.1372C11.3553 23.1372 10.7919 23.5934 10.7919 24.1562V34.5759V44.7199C10.7919 45.2827 11.5981 46.0287 12.2925 46.0287L16.6965 46.0146L27.316 35.2108C27.6716 34.8494 27.6716 34.3025 27.3165 33.941Z"
          fill="#039D55"
        />
        <path
          d="M27.3165 33.941L19.799 26.2931C17.8246 24.2846 15.0072 23.1372 12.0497 23.1372C11.3553 23.1372 10.7919 23.5934 10.7919 24.1562V34.5759V44.7199C10.7919 45.2827 11.5981 46.0287 12.2925 46.0287L16.6965 46.0146L27.316 35.2108C27.6716 34.8494 27.6716 34.3025 27.3165 33.941Z"
          fill={alpha(theme.palette.primary.main, 10)}
        />
        <path
          d="M44.4794 40.4266V44.8351C44.4794 45.4941 43.8074 46.0283 42.9789 46.0283H12.2925C11.464 46.0283 10.7919 45.4941 10.7919 44.8351V40.4266L26.7008 30.3529C26.9595 30.1892 27.2696 30.1026 27.5829 30.0935C27.9308 30.0836 28.2823 30.1706 28.571 30.3529L44.4794 40.4266Z"
          fill={alpha(theme.palette.primary.main, 10)}
        />
        <path
          d="M10.7919 38.5887L24.6363 31.2139L24.9069 31.4896L10.7919 40.4272V38.5887Z"
          fill="#090909"
          fillOpacity="0.11"
        />
        <path
          d="M44.4794 38.5887L30.6349 31.2139L30.3644 31.4896L44.4794 40.4272V38.5887Z"
          fill="#090909"
          fill-opacity="0.11"
        />
        <path
          d="M27.5829 25.5034C25.9718 25.5034 24.6659 26.8059 24.6659 28.4126H30.5004C30.4999 26.8059 29.194 25.5034 27.5829 25.5034Z"
          fill={alpha(theme.palette.primary.main, 10)}
        />
        <path
          d="M27.5828 25.2847C28.4166 25.2847 29.0925 24.6106 29.0925 23.7791C29.0925 22.9475 28.4166 22.2734 27.5828 22.2734C26.7491 22.2734 26.0732 22.9475 26.0732 23.7791C26.0732 24.6106 26.7491 25.2847 27.5828 25.2847Z"
          fill={alpha(theme.palette.primary.main, 10)}
        />
        <path
          d="M42.0058 5.53898C42.0058 5.7424 41.925 5.92778 41.7908 6.0623C41.6599 6.19682 41.4773 6.28048 41.2768 6.28048H25.6827C25.2819 6.28048 24.9538 5.94746 24.9538 5.54062C24.9538 5.3372 25.0346 5.15182 25.1687 5.0173C25.2997 4.88278 25.4823 4.79911 25.6827 4.79911H26.4198C26.7107 4.11338 27.3831 3.63272 28.1654 3.63272C28.6923 3.63272 29.1675 3.8509 29.5134 4.20197C29.9724 3.41125 30.8193 2.87973 31.7907 2.87973C32.0574 2.87973 32.3144 2.92074 32.5569 2.99456C33.0644 2.02667 34.0665 1.36719 35.2238 1.36719C36.6122 1.36719 37.7792 2.31868 38.1315 3.61303C38.3869 3.48343 38.6762 3.40961 38.9817 3.40961C39.848 3.40961 40.577 3.99691 40.8081 4.79911H41.2768C41.6777 4.79911 42.0058 5.13213 42.0058 5.53898Z"
          fill={alpha(theme.palette.primary.main, 10)}
          fillOpacity="0.3"
        />
      </g>
      <defs>
        <clipPath id="clip0_373_3494">
          <rect
            width="57.2254"
            height="50"
            fill="white"
            transform="translate(0.387283 0.5)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};

export default SubscribeImage;
